<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Service Help Section</title> 
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .help-asap-section {
      display: flex;
      flex-wrap: wrap;
      width: 100%;
      min-height: 100vh;
    }

    .help-asap-left {
      flex: 1;
      background-color: #f9f9f9;
      padding: 60px 40px;
      display: flex;
      flex-direction: column;
      justify-content: center;
    }

    .help-asap-left h2 {
      font-size: 40px;
      margin-bottom: 20px;
      color: #333;
    }

    .help-asap-left p {
      font-size: 16px;
      line-height: 1.6;
      color: #555;
    }

    .help-asap-left .btn-learn-more {
      margin-top: 30px;
      padding: 12px 25px;
      background-color: #00b6bd;
      color: #fff;
      text-decoration: none;
      font-weight: bold;
      border-radius: 4px;
      width: fit-content;
    }

    .help-asap-right {
      flex: 1;
      display: flex;
      flex-direction: column;
    }

    .help-asap-image {
      flex: 1;
      background-image: url('https://atozservice.in/images/nearme/fridge.jpg'); /* Replace with your actual image */
      background-size: cover;
      background-position: center;
      min-height: 300px;
    }

    .help-asap-services {
      display: flex;
      flex-wrap: wrap;
      text-align: center;
    }

    .help-asap-box {
      flex: 1 1 50%;
      padding: 40px 20px;
      color: #000;
    }

    .help-asap-box.yellow {
      background-color: #fcd758;
    }

    .help-asap-box.teal {
      background-color: #00b6bd;
      color: #fff;
    }

    .help-asap-box i {
      font-size: 30px;
      margin-bottom: 10px;
      display: block;
    }

    @media (max-width: 768px) {
      .help-asap-section {
        flex-direction: column;
      }

      .help-asap-box {
        flex: 1 1 100%;
      }

      .help-asap-left {
        padding: 30px 20px;
      }

      .help-asap-left h2 {
        font-size: 30px;
      }
    }
  </style>
</head>
<body>
<div data-aos="fade-right"><section class="help-asap-section">
  <div class="help-asap-left">
    <h2>Need help Krish Home Appliances?</h2>
    <p>
      Our services are superior, from flawless installation to frequent maintenance,
      lightning-fast emergency repairs, AC rentals and comprehensive Annual Maintenance
      Contracts. Don't settle for anything less than the best - choose us and experience
      unparalleled quality and reliability in every aspect of your project. Trust us,
      your satisfaction is guaranteed.
    </p>
    <a href="services" class="btn-learn-more">LEARN MORE</a>
  </div>

  <div class="help-asap-right">
    <div class="help-asap-image"></div>
    <div class="help-asap-services">
      <div class="help-asap-box yellow">
        <i>❄️</i>
        
        <p>Washing Machine Repair & Service</p>
      </div>
      <div class="help-asap-box teal">
        <i>🔧</i>
        <p>RO Machine - Repair & Service</p>
        <p>Refrigerator Repair & Service</p>
      </div>
    </div>
  </div>
</section></div>
<script>
  AOS.init();
</script>

</body>
</html>
