<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Service Page</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
    }
    .hero-section {
      background-color:#F7AD45;
      padding: 60px 0;
    }
    .hero-section h2 {
      font-weight: 700;
    }
    .hero-section p {
      margin-top: 10px;
      font-size: 16px;
    }
    .btn-custom {
      background-color: #00bcd4;
      color: #fff;
      border: none;
      padding: 10px 20px;
      margin-top: 20px;
    }
    .info-section {
      background-color:#F7AD45;
      padding: 40px 0;
      border-top: 1px solid #d1a637;
      border-bottom: 1px solid #d1a637;
    }
    .info-icon {
      font-size: 24px;
      margin-right: 10px;
      color: #333;
    }
    .footer {
      background-color:#F7AD45;
      padding: 15px 20px;
      text-align: center;
      font-size: 14px;
      border-top: 1px solid #ccc;
    }
    .social-icons a {
      color: #000;
      margin-left: 10px;
      text-decoration: none;
      font-size: 18px;
    }
    .info-section .col-md-4 {
  text-align: left !important;
}

  </style>
</head>
<body>

  <div class="container-fluid hero-section">
    <div class="row align-items-center">
      <div class="col-md-6 text-center mb-4 mb-md-0">
        <img src="images/Owner-684-by-1024-pixels.jpg" alt="Worker with Tools" class="img-fluid" style="max-height: 500px;">
      </div>
      <div class="col-md-6 text-center text-md-start">
        <h2>Focus On Getting Our Jobs Done</h2>
        <p>We firmly believe that customer satisfaction is very important and we go extra mile to make our customers happy.</p>
        <a href="tel:+919566871551">
          <button class="btn btn-custom">FREE CONSULTATION</button>
        </a>
      </div>
    </div>
  </div>

  <div class="container-fluid info-section">
  <div class="row gy-4 px-3 px-md-5">
    <div class="col-md-4">
      <div class="d-flex align-items-start mb-2">
        <span class="info-icon">📍</span>
        <strong>Address:</strong>
      </div>
      <p class="mb-0">Krish Home Appliances<br>
        E block, 63, Dr. Thomas Road<br>
        T.Nagar, Chennai 600017</p>
    </div>
    <div class="col-md-4">
      <div class="d-flex align-items-start mb-2">
        <span class="info-icon">📧</span>
        <strong>Email:</strong>
      </div>
      <p class="mb-0">krishhomeappliance@gmail.com</p>
    </div>
    <div class="col-md-4">
      <div class="d-flex align-items-start mb-2">
        <span class="info-icon">⏰</span>
        <strong>Open Hours:</strong>
      </div>
      <p class="mb-0">Mon-Sun: 8am - 8pm</p>
    </div>
  </div>
</div>


  <footer class="footer">
    <div class="row align-items-center">
      <div class="col-md-6 text-center text-md-start mb-2 mb-md-0">
        &copy; <span id="currentYear"></span> Newline Technology. All Rights Reserved.
      </div>
      <div class="col-md-6 text-center text-md-end">
        <div class="social-icons">
          <a href="https://facebook.com" target="_blank"><i class="bi bi-facebook"></i></a>
          <a href="https://twitter.com" target="_blank"><i class="bi bi-twitter-x"></i></a>
          <a href="https://instagram.com" target="_blank"><i class="bi bi-instagram"></i></a>
          <a href="https://linkedin.com" target="_blank"><i class="bi bi-linkedin"></i></a>
          <a href="https://youtube.com" target="_blank"><i class="bi bi-youtube"></i></a>
          <a href="mailto:krishhomeappliance@gmail.com?subject=Enquiry&body=Hello,%20I%20would%20like%20to%20know%20more%20about...">
            <i class="bi bi-envelope-fill"></i>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <script>
    document.getElementById("currentYear").textContent = new Date().getFullYear();
  </script>

</body>
</html>
