<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Custom FAQ Accordion</title>
  <style>
    .faq-container-unique {
      font-family: Arial, sans-serif;
      max-width: 800px;
      margin: 0 auto;
    }

    .faq-title-unique {
      text-align: center;
      font-size: 2rem;
      font-weight: bold;
      margin-bottom: 20px;
    }

    .faq-item-unique {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 4px;
      overflow: hidden;
    }

    .faq-question-unique {
      background-color: #00b4c5;
      color: white;
      padding: 15px 20px;
      cursor: pointer;
      position: relative;
      font-weight: bold;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .faq-question-unique::before {
      content: '+';
      font-size: 1.2rem;
      margin-right: 10px;
    }

    .faq-item-unique.open .faq-question-unique::before {
      content: '−';
    }

    .faq-answer-unique {
      background-color: #fff;
      color: #333;
      padding: 20px;
      display: none;
    }

    .faq-item-unique.open .faq-answer-unique {
      display: block;
    }
  </style>
</head>
<body>
  <div class="faq-container-unique">
    <div class="faq-title-unique">FAQ</div>

    <div class="faq-item-unique open">
      <div class="faq-question-unique">Is the Refrigerator not cooling?</div>
      <div class="faq-answer-unique">
        Solution: Check that the temperature settings are set to the recommended level and ensure that the condenser coils are clean. It is essential to maintain the coils, as dirty ones can limit airflow and reduce the cooling efficiency. If the issue persists, it may be a problem with the compressor or another component, which will require professional repair.
      </div>
    </div>

    <div class="faq-item-unique">
      <div class="faq-question-unique">Is the Refrigerator leaking water?</div>
      <div class="faq-answer-unique">
        Solution: Ensure that the defrost drain is not clogged. A blocked drain can cause water to pool and leak. Clear any obstructions and verify that the drain pan is in place and not cracked.
      </div>
    </div>
  </div>

  <script>
    document.querySelectorAll('.faq-question-unique').forEach(button => {
      button.addEventListener('click', () => {
        const faqItem = button.parentElement;
        faqItem.classList.toggle('open');
      });
    });
  </script>
</body>
</html>
