<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Contact Us - Krish Home Appliances</title>

  <!-- Bootstrap Icons CDN (for optional envelope icon if needed) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f5f5f5;
    }

    .custom-contact-section {
      padding: 60px 20px;
      background-color: #fff;
      text-align: center;
    }

    .custom-contact-container {
      max-width: 800px;
      margin: 0 auto;
    }

    .custom-contact-heading {
      font-size: 48px;
      font-weight: 700;
      color: #2b2b2b;
      margin-bottom: 10px;
    }

    .custom-contact-divider {
      height: 40px;
      width: 2px;
      background-color: #00bcd4;
      margin: 0 auto 30px auto;
    }

    .custom-contact-subheading {
      font-size: 24px;
      font-weight: 600;
      color: #2b2b2b;
      margin-bottom: 20px;
    }

    .custom-contact-text {
      font-size: 16px;
      color: #4a4a4a;
      margin-bottom: 30px;
    }

    .custom-contact-form {
      margin-bottom: 40px;
    }

    .custom-contact-phone-btn,
    .custom-contact-email-btn {
      display: inline-block;
      margin: 10px 5px;
      padding: 14px 24px;
      border-radius: 5px;
      font-size: 18px;
      font-weight: 500;
      text-decoration: none;
      transition: background-color 0.3s ease;
    }

    .custom-contact-phone-btn {
      background-color: #00bcd4;
      color: white;
    }

    .custom-contact-phone-btn:hover {
      background-color: #0097a7;
    }

    .custom-contact-email-btn {
      background-color: #4caf50;
      color: white;
    }

    .custom-contact-email-btn:hover {
      background-color: #388e3c;
    }

    .custom-phone-icon,
    .custom-email-icon {
      margin-right: 10px;
      font-size: 18px;
    }

    @media (max-width: 600px) {
      .custom-contact-phone-btn,
      .custom-contact-email-btn {
        display: block;
        width: 100%;
        margin: 10px 0;
      }
    }
  </style>
</head>
<body>

<section class="custom-contact-section">
  <div class="custom-contact-container">
    <h2 class="custom-contact-heading">Contact Us Today!</h2>
    <div class="custom-contact-divider"></div>

    <h3 class="custom-contact-subheading">
      We Offer <strong>24/7 Emergency Service</strong> To All of Our Customers
    </h3>

    <p class="custom-contact-text">
    Don’t let appliance issues disrupt your daily routine. Reach out to Krish Home Appliances for reliable service and support. Whether you need a quick repair or routine maintenance, we’re here to help.

    </p>

    <div class="custom-contact-form">
      <!-- Optional contact form goes here -->
    </div>

    <a href="tel:+919566871551" class="custom-contact-phone-btn">
      <span class="custom-phone-icon">📞</span> +919566871551
    </a>

    <a href="mailto:krishhomeappliance@gmail.com?subject=Enquiry&body=Hello,%20I%20would%20like%20to%20know%20more%20about..." class="custom-contact-email-btn">
      <span class="custom-email-icon">✉️</span> krishhomeappliance@gmail.com
    </a>

  </div>
</section>

</body>
</html>
